FILESEXTRAPATHS_append := ":${THISDIR}/${PN}"

SRC_URI_append = " \
                   file://systemd-udevd.service \
                   file://systemd-udevd-nand.service \
                   file://0001-logind-disable-handle-the-power-key-event.patch \
"

inherit systemd

PACKAGECONFIG[networkd] = "-Dnetworkd=false"
EXTRA_OEMESON += "-Dmemory-accounting-default=false"

do_install_append() {
    if ${@bb.utils.contains('IMAGE_FEATURES','read-only-rootfs','true','false',d)}; then
        ln -nfs ../var/run/connman/resolv.conf ${D}${sysconfdir}/resolv.conf
    fi
    install -d ${D}${systemd_unitdir}/system/
    if [ "${@bb.utils.contains('BOOTDEV_TYPE','emmc','yes','no',d)}" = "yes" ]; then
        cp ${WORKDIR}/systemd-udevd.service ${D}${systemd_unitdir}/system/
    else
        cp ${WORKDIR}/systemd-udevd-nand.service ${D}${systemd_unitdir}/system/systemd-udevd.service
    fi

    #create symblic for syslog to always active syslog.socket
    cd  ${D}${systemd_unitdir}/system/sockets.target.wants/
    ln -sf ../syslog.socket syslog.socket
}
